# YouTube API Services - Quota Extension Request

This document contains all information required to fill out the YouTube API Services - Audit and Quota Extension Form for MiBa Video Manager.

**Form URL:** https://support.google.com/youtube/contact/yt_api_form

---

## General Information

### Reason for Filling This Form
- **I am completing a Compliance Audit or requesting additional API quota**

### Your Full Legal Name
- **Michael Bachmann**

### Your Organization's Name
- **N/A: Individual developer**

### Your Organization's Website
- **https://www.miba.dk/miba-video-manager**
- Must start with https://

### Your Organization's Address
- **19 Navarra Drive (B13L1), South Forbes Villas, Brgy. Inchican, Silang, Cavite 4118, Philippines**

### Organization Contact Email Address
- **miba@miba.dk**
- Actively monitored email address for service announcements or contacts for further information

### Describe Your Organization's Work as It Relates to YouTube
- **MiBa Video Manager is a desktop application built with Electron that helps content creators manage their local video files and upload them to YouTube. The application provides features for organizing video libraries, managing video metadata (title, description, privacy settings), uploading videos to YouTube channels, and managing existing YouTube video content. The application serves as a creator tool that simplifies the video publishing workflow by allowing users to monitor local video directories, preview videos, and directly upload to YouTube with customizable metadata. It targets individual content creators and small video producers who need an efficient desktop solution for YouTube content management. The application uses Google OAuth 2.0 for secure authentication and implements caching mechanisms to optimize API usage and improve user experience.**
- *Note: This description exceeds 100 characters as required*

### Google Representative Email Address
- *(Leave blank if no working relationship with a Google employee)*

### Content Owner ID (if available)
- *(Leave blank if not available)*

---

## API Client Information

An "API Client" is your website or software application that accesses or uses YouTube API Services.

### Have You Undergone an Audit Since June 2019?
- **No**

### Is There Any Way in Which Your Client's Use of the YT API Changed Since the Last Audit?
- **N/A** (No previous audit)

### Please List All Your API Client(s)
- **MiBa Video Manager**

### Please List All the Project Numbers Used for Each of Your API Client(s)
- **\[TO BE FILLED IN\]** - The project number is a series of digits that can be found alongside the Project ID in your Google Cloud Console.
- **Project ID:** `miba-video-manager` (from `config/google-oauth.json`)
- *Note: The project number must contain exclusively numeric values and should be obtained from Google Cloud Console*

### Is This a Publicly or Privately Available API Client?
- **Publicly accessible**

### Please Provide Details on How API Client Accesses the YouTube Data API
- The application uses the Google APIs Node.js Client Library (`googleapis` v131.0.0) to access YouTube Data API v3.
- Authentication is performed using Google OAuth 2.0 desktop flow with PKCE (Proof Key for Code Exchange) for enhanced security.
- The application implements secure OAuth flows as per Google's security requirements, including CSRF protection via state tokens and ephemeral session secrets stored in memory only.
- API calls are made from the Electron main process using authenticated OAuth clients obtained through the `googleOAuth.getAuthenticatedClient()` method.

### Where Can We Find Each API Client(s)?
- **Website/Homepage:** https://www.miba.dk/miba-video-manager
- **Demo Video:** https://www.youtube.com/watch?v=3gCD1y3SQhs
- **Application Type:** Desktop application (Electron) for Windows and macOS
- The application is publicly available but may require download and installation from the project website.

### If There Is a Log-in Required to Access the API Client, Please Provide a Demo Account and Instructions
- **Not applicable** - The application does not require user registration. Users authenticate directly with their Google/YouTube accounts through the integrated OAuth flow. The application can be accessed by any user who installs the desktop application and authenticates with their own Google credentials.

### Does Your API Client Commercialize YouTube Data?
- **No**
- The application is a free tool for content creators. It does not generate revenue through sales, ads, paid subscriptions, or monetization of YouTube Data.

### Choose the Option That Best Resembles Your API Client's Use Case
- **Creator Tools**

### List Other Use Cases for the API Client
- *(Leave blank if "Creator Tools" fully describes the use case)*

### Specify All YouTube API Services Used by This API Client
- **Data API** ✓
- Analytics API - No
- Reporting API - No
- Content ID API - No
- Embeds - No
- Live Streaming API - No

### Select the Primary Audience for Your API Client
- **Creators**

### Approximately How Many Users Use Your API Client?
- **10-15 users**

### Explain How Your API Client Is Used by Your Users
- Users install the MiBa Video Manager desktop application on their Windows or macOS systems.
- Users add local directories containing video files to monitor. The application automatically scans these directories and displays videos organized by folder structure.
- Users authenticate with their Google/YouTube account through the built-in OAuth 2.0 flow to connect their YouTube channel.
- Users can upload local video files directly to their YouTube channel, setting custom titles, descriptions, and privacy settings during upload.
- Users can view and manage their existing YouTube video library, including the ability to update video metadata (title, description, privacy status) and delete videos from YouTube.
- The application provides a video player for previewing local videos before upload.
- Users can track upload progress in real-time and see which local videos have been uploaded to YouTube through visual indicators in the interface.

### Does Your API Client Use Multiple Projects to Access YouTube APIs?
- **No**
- The application uses a single Google Cloud Project: `miba-video-manager`

### Does This API Client Create, Access, or Use Any Metrics Derived from YouTube Data?
- **No**
- The application displays YouTube video metadata (title, description, views, etc.) directly from the API response but does not create derived metrics or analytics from YouTube Data.

### Does This API Client Display Data from, or Provide Features or Services Across, Multiple Platforms?
- **No**
- The application focuses exclusively on YouTube integration. It does not integrate with other platforms like Facebook, Twitter, or other video platforms.

### Do You Create/Provide Any Type of Reports Using YouTube API Data?
- **No**
- The application does not generate reports. It provides direct management of YouTube content (upload, update, delete) and displays video information for user reference.

### How Long Do You Store YouTube API Data?
- **1 - 7 days**
- YouTube API data is cached locally on the user's device for performance optimization. The default cache duration for library data is 60 seconds (DEFAULT_LIBRARY_CACHE_MS = 60 * 1000). Video records are stored in local JSON files (`youtube-videos-{accountId}.json`) and library cache files (`youtube-cache/{accountId}.json`) in the application's user data directory. Cache is refreshed on-demand and when users manually refresh their YouTube library. The cached data is stored per-user on their local machine and is not shared or transmitted to any external servers.

### How Often Do You Refresh YouTube API Data?
- **1 week** (or on-demand)
- The application implements a multi-tier caching strategy:
  - In-memory cache with 60-second default TTL (configurable via DEFAULT_LIBRARY_CACHE_MS)
  - Disk-based cache that persists between application sessions
  - Cache is refreshed on-demand when users explicitly request a library refresh
  - Cache is automatically invalidated after video uploads, updates, or deletions
  - Channel information is cached for 5 minutes before requiring refresh

### Does This API Client Allow Users to Authenticate with Their Google Credentials?
- **Yes**

### Please Provide More Detail on How Many Users Have Authenticated to Your API Client, and How Authenticated Data Is Used
- **Authenticated users:** Approximately 10-15 users (matching total user base)
- **Authentication usage:**
  - All users who upload videos or manage YouTube content must authenticate with their Google/YouTube account
  - Authentication uses Google OAuth 2.0 desktop flow with PKCE (Proof Key for Code Exchange) for security
  - OAuth scopes requested: `youtube`, `youtube.upload`, and `youtube.force-ssl`
  - Authenticated credentials are stored securely on the user's local device using Electron's secure token storage
  - Each authenticated user's data is stored separately per account ID in local JSON files
  - Authenticated data is used exclusively to:
    - Upload videos to the user's YouTube channel
    - Retrieve and display the user's YouTube video library
    - Update video metadata (title, description, privacy settings)
    - Delete videos from the user's YouTube channel
  - No authenticated data is shared between users or transmitted to external servers

### Send Documents Relating to Your Implementation
- **Documentation files to upload:**
  - `docs/auth/google-oauth.md` - Describes the OAuth 2.0 implementation and security measures
  - `src/main/youtube.js` - Main YouTube API integration code
  - Demo video: https://www.youtube.com/watch?v=3gCD1y3SQhs
  - *Note: Upload one file smaller than 10MB. Multiple file uploads or files greater than 10 MB will result in an error during submission.*

---

## Quota Request Form

*Only fill out and submit this section if you are nearing your allocated quota limit*

### Which API Client Are You Requesting a Quota Increase For?
- **MiBa Video Manager**

### What API Project Number Are You Requesting Increased Quota For?
- **\[TO BE FILLED IN\]** - Enter your project number as shown on Google Developer Console
- **Project ID:** `miba-video-manager`
- *Note: The project number must be a numeric value*

### Which YouTube API Service(s) Are You Requesting a Quota Increase For?
- **Data API** ✓

### How Much "Additional Quota" Are You Requesting?
- **100,000 units**
- "Additional Quota" = "Total Quota Needed" - "Current Allocated Quota"
- Total Quota Needed: 110,000 units
- Current Allocated Quota: 10,000 units
- Additional Quota Requested: 100,000 units

### Justification for Requesting Additional Quota?
- **As the application has not seen much usage it is a bit difficult to predict. Some assumptions for an average user:**
  
  **Video Uploads:** 5 uploads × 1,600 points = 8,000 points
  
  **Metadata Updates:** 5 updates × 50 points = 250 points
  
  **Directory Listings (Library Refresh):** 10 listings × 1 point = 10 points
  
  **Total per user:** 8,260 points
  
  **Estimated user base:** 10-15 users
  
  **Expected total usage:** 82,600 - 123,900 points per day across all users
  
  **Requested quota of 100,000 would support approximately 10-15 users with room for growth.**
  
  **Expected growth and timelines:**
  - Current user base: 10-15 users
  - Application is publicly available and may see gradual organic growth
  - Quota request accounts for current users plus moderate growth over the next 12 months
  
  **Daily usage pattern:**
  - Peak usage: Users may batch upload multiple videos in a session
  - Average daily usage per user: ~8,260 points (based on assumptions above)
  - Total daily usage: ~82,600 - 123,900 points for 10-15 users
  - Peak QPS: Low (desktop application with manual user actions)
  
  **Expected number of calls:**
  - Video uploads: ~50-75 uploads/day (5 uploads × 10-15 users) = 80,000-120,000 points/day
  - Metadata updates: ~50-75 updates/day (5 updates × 10-15 users) = 2,500-3,750 points/day
  - Library refresh: ~100-150 calls/day (10 calls × 10-15 users) = 100-150 points/day
  - Channel info: ~20-30 calls/day (cached, but refreshed periodically) = ~50-75 points/day
  - **Total: ~83,000 - 124,000 points/day**

### Explain in Detail How You Use YouTube API Services Today
- **Current API usage breakdown:**
  
  1. **Channel Information Retrieval** (`channels.list`)
     - Used to fetch channel details, channel ID, and uploads playlist ID
     - Called when user connects their YouTube account
     - Called periodically to refresh channel information (cached for 5 minutes)
     - API cost: ~1 unit per call
     - Usage: ~2-3 calls per user per day (typically on app start and manual refresh)
  
  2. **Video Uploads** (`videos.insert`)
     - Used to upload local video files to the user's YouTube channel
     - Supports setting title, description, privacy status, and category during upload
     - Includes file stream upload with progress tracking
     - API cost: 1,600 units per upload
     - Usage: Varies by user activity, estimated 5 uploads per user per day on average
  
  3. **Video Metadata Updates** (`videos.update`)
     - Used to update existing YouTube video metadata (title, description, privacy status, category, tags)
     - Called when user edits video information through the application interface
     - API cost: ~50 units per update
     - Usage: Estimated 5 updates per user per day on average
  
  4. **Video Deletion** (`videos.delete`)
     - Used to delete videos from the user's YouTube channel
     - API cost: ~50 units per deletion
     - Usage: Occasional, estimated <1 deletion per user per day on average
  
  5. **Video Library Retrieval** (`videos.list` + `playlistItems.list`)
     - Used to fetch user's uploaded videos and display them in the library view
     - Fetches up to 200 videos from the uploads playlist
     - Retrieves detailed video information including metadata, thumbnails, and status
     - API cost: ~1-2 units per call (varies by number of videos fetched)
     - Usage: Called on-demand when user refreshes library (cached to minimize API calls)
  
  6. **Playlist Information** (`playlists.list`)
     - Used to fetch user's playlists (optional feature)
     - API cost: ~1 unit per call
     - Usage: Minimal, primarily for future features
  
  **Caching Strategy:**
  - The application implements aggressive caching to minimize API calls
  - Channel information cached for 5 minutes
  - Library data cached in-memory (60 seconds) and on disk (persistent)
  - Cache is invalidated on upload/update/delete operations
  - This caching significantly reduces API quota consumption

### What Functionality Would Your API Client Be Lacking Without More Quota?
- **Without the requested quota increase, the application would face significant limitations:**
  
  1. **User Capacity Restrictions:**
     - Current quota of 10,000 units per day can only support approximately 1 user with typical usage patterns (8,260 points per user)
     - With 10-15 active users, the application would immediately hit quota limits
     - Users would be unable to upload videos or manage their YouTube content
  
  2. **Feature Degradation:**
     - Video upload functionality would become unavailable (most quota-intensive operation at 1,600 units per upload)
     - Users would be unable to batch upload multiple videos in a session
     - Library refresh would need to be heavily restricted or disabled
  
  3. **User Experience Impact:**
     - Error messages about quota exhaustion would frustrate users
     - Users would need to wait until the next day to use the application
     - The application's core value proposition (seamless YouTube video management) would be compromised
  
  4. **Growth Limitations:**
     - Unable to support additional users
     - Current users would experience service interruptions
     - Application cannot scale to meet user demand

### What Potential Workarounds Would You Use to Compensate for Less Quota?
- **If quota is not increased, we would implement the following workarounds:**
  
  1. **Stricter Caching:**
     - Increase cache duration from 60 seconds to 24 hours for library data
     - Implement more aggressive cache validation to reduce unnecessary API calls
     - Trade-off: Users may see stale data
  
  2. **Decreased Feature Set:**
     - Limit video uploads to one per user per day
     - Disable library refresh functionality or limit to once per day
     - Remove playlist management features
     - Trade-off: Significantly reduced functionality and user value
  
  3. **User Restrictions:**
     - Implement user registration or queue system to limit active users
     - Prioritize certain users or implement quota allocation per user
     - Trade-off: Limits accessibility and growth potential
  
  4. **Batch Processing:**
     - Queue video uploads and process them during off-peak hours
     - Implement user notifications when quota is low
     - Trade-off: Delayed uploads, poor user experience
  
  5. **Quota Monitoring:**
     - Implement real-time quota tracking and warnings
     - Alert users when quota is approaching limits
     - Automatically disable features when quota is exhausted
     - Trade-off: Complex implementation, still limits functionality
  
  **However, these workarounds significantly compromise the application's core functionality and user experience. The requested quota increase is essential for providing a viable service to the current user base.**

---

## Acknowledgment of YouTube API Services Terms of Service and Developer Policies

### I Have Read and Agree to the YouTube API Services Terms of Service
- **Yes** ✓
- I acknowledge that I have read and agree to the YouTube API Services Terms of Service (including the Developer Policies and Google Privacy Policy), and my current and proposed access to, and use of, YouTube API Service(s) comply with the YouTube API Services Terms of Service.

### If I Provide a Demo Account and Instructions
- **I agree** ✓
- I understand and agree that if I provide a demo account and instructions on how Google can access my API Client, Google is not bound to any terms of service or policies that applies to such account or access to my API Client.

### The Above Facts Are True
- **I agree** ✓
- The above facts are true to the best of my knowledge and I understand that should the above facts be found to be untrue, YouTube may terminate my API Client's access to the YouTube API Services as per YouTube's Terms of Service and Developer Policies.

---

## Additional Notes

### YouTube API Endpoints Used
Based on codebase analysis (`src/main/youtube.js`):

- `channels.list` - Retrieve channel information
- `videos.insert` - Upload videos (1,600 units per upload)
- `videos.update` - Update video metadata (50 units per update)
- `videos.delete` - Delete videos (50 units per deletion)
- `videos.list` - Retrieve video details
- `playlistItems.list` - Retrieve playlist items (uploads playlist)
- `playlists.list` - Retrieve playlist information

### Authentication Implementation
- Google OAuth 2.0 desktop flow with PKCE (Proof Key for Code Exchange)
- CSRF protection via state tokens
- Ephemeral session secrets stored in memory only
- Secure token storage using Electron's secure storage APIs
- OAuth scopes: `youtube`, `youtube.upload`, `youtube.force-ssl`
- Documentation: `docs/auth/google-oauth.md`

### Data Storage and Privacy
- All data stored locally on user's device
- No data transmitted to external servers except YouTube API
- Per-user data isolation (separate files per account ID)
- Cache files stored in application's user data directory
- No sharing of data between users or external parties

### Technical Details
- **Application Type:** Electron desktop application
- **Supported Platforms:** Windows (x64), macOS (x64, arm64)
- **API Client Library:** googleapis v131.0.0
- **YouTube API Version:** v3
- **Programming Language:** Node.js/JavaScript

---

## Submission Checklist

Before submitting the form, ensure you have:

- [ ] Filled in the Google Cloud Project Number (numeric value from Google Cloud Console)
- [ ] Prepared documentation file for upload (if required, ensure file is < 10MB)
- [ ] Reviewed all answers for accuracy
- [ ] Confirmed contact email (miba@miba.dk) is correct and actively monitored
- [ ] Verified organization address is current
- [ ] Read and understood YouTube API Services Terms of Service
- [ ] Ready to provide demo account information if requested

---

**Last Updated:** 2025-01-XX  
**Document Version:** 1.0  
**For Reference Only:** This document is a preparation tool for filling out the official YouTube API quota request form.

